/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import me.jddev0.ep.block.ConfigurableTransformerBlock;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.TransformerBlock;
import me.jddev0.ep.block.entity.base.ConfigurableEnergyStorageBlockEntity;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.tier.TransformerTier;
import me.jddev0.ep.machine.tier.TransformerType;
import me.jddev0.ep.screen.TransformerMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class TransformerBlockEntity
extends ConfigurableEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    private final TransformerTier tier;
    private final TransformerType type;
    final EnergizedPowerLimitingEnergyStorage limitingEnergyStorageInsert;
    final EnergizedPowerLimitingEnergyStorage limitingEnergyStorageExtract;

    public TransformerBlockEntity(class_2338 blockPos, class_2680 blockState, TransformerTier tier, TransformerType type) {
        super(tier.getEntityTypeFromTierAndType(type), blockPos, blockState, tier.getMachineNameFromTierAndType(type), tier.getMaxEnergyTransferFromTier(), tier.getMaxEnergyTransferFromTier());
        this.tier = tier;
        this.type = type;
        this.limitingEnergyStorageInsert = new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L);
        this.limitingEnergyStorageExtract = new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyTransferRate, this.baseEnergyTransferRate, this.baseEnergyTransferRate){

            protected void onFinalCommit() {
                TransformerBlockEntity.this.method_5431();
                TransformerBlockEntity.this.syncEnergyToPlayers(32);
            }

            @Override
            public long extract(long maxAmount, TransactionContext transaction) {
                if (TransformerBlockEntity.this.field_11863 != null && !TransformerBlockEntity.this.redstoneMode.isActive((Boolean)TransformerBlockEntity.this.field_11863.method_8320(TransformerBlockEntity.this.method_11016()).method_11654((class_2769)class_2741.field_12484))) {
                    return 0L;
                }
                return super.extract(maxAmount, transaction);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, this.baseEnergyTransferRate);
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new TransformerMenu(id, this, inventory, this.data);
    }

    public TransformerType getTransformerType() {
        return this.type;
    }

    public TransformerTier getTier() {
        return this.tier;
    }

    EnergyStorage getEnergyStorageForDirection(class_2350 side) {
        if (side == null) {
            return this.energyStorage;
        }
        if (this.type == TransformerType.CONFIGURABLE) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            EPBlockStateProperties.TransformerConnection transformerConnection = (EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(ConfigurableTransformerBlock.getTransformerConnectionPropertyFromDirection(side)));
            return switch (transformerConnection) {
                default -> throw new MatchException(null, null);
                case EPBlockStateProperties.TransformerConnection.NOT_CONNECTED -> null;
                case EPBlockStateProperties.TransformerConnection.RECEIVE -> this.limitingEnergyStorageInsert;
                case EPBlockStateProperties.TransformerConnection.EXTRACT -> this.limitingEnergyStorageExtract;
            };
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)TransformerBlock.FACING);
        return switch (this.type) {
            case TransformerType.TYPE_1_TO_N, TransformerType.TYPE_N_TO_1 -> {
                EnergizedPowerLimitingEnergyStorage multipleSide;
                EnergizedPowerLimitingEnergyStorage singleSide = this.type == TransformerType.TYPE_1_TO_N ? this.limitingEnergyStorageInsert : this.limitingEnergyStorageExtract;
                EnergizedPowerLimitingEnergyStorage v1 = multipleSide = this.type == TransformerType.TYPE_1_TO_N ? this.limitingEnergyStorageExtract : this.limitingEnergyStorageInsert;
                if (facing == side) {
                    yield singleSide;
                }
                yield multipleSide;
            }
            case TransformerType.TYPE_3_TO_3 -> {
                if (facing.method_35834(class_2350.class_2351.field_11048) == side || facing.method_35834(class_2350.class_2351.field_11052) == side || facing.method_35834(class_2350.class_2351.field_11051) == side) {
                    yield this.limitingEnergyStorageInsert;
                }
                yield this.limitingEnergyStorageExtract;
            }
            default -> null;
        };
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, TransformerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        TransformerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, TransformerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            return;
        }
        ArrayList<class_2350> outputDirections = new ArrayList<class_2350>();
        if (blockEntity.type == TransformerType.CONFIGURABLE) {
            for (class_2350 side : class_2350.values()) {
                EPBlockStateProperties.TransformerConnection transformerConnection = (EPBlockStateProperties.TransformerConnection)((Object)state.method_11654(ConfigurableTransformerBlock.getTransformerConnectionPropertyFromDirection(side)));
                if (!transformerConnection.isExtract()) continue;
                outputDirections.add(side);
            }
        } else {
            class_2350 facing = (class_2350)state.method_11654((class_2769)TransformerBlock.FACING);
            block21: for (class_2350 side : class_2350.values()) {
                switch (blockEntity.getTransformerType()) {
                    case TYPE_1_TO_N: 
                    case TYPE_N_TO_1: {
                        boolean isOutputMultipleSide;
                        boolean isOutputSingleSide = blockEntity.getTransformerType() != TransformerType.TYPE_1_TO_N;
                        boolean bl = isOutputMultipleSide = blockEntity.getTransformerType() == TransformerType.TYPE_1_TO_N;
                        if (facing == side) {
                            if (!isOutputSingleSide) continue block21;
                            outputDirections.add(side);
                            continue block21;
                        }
                        if (!isOutputMultipleSide) continue block21;
                        outputDirections.add(side);
                        continue block21;
                    }
                    case TYPE_3_TO_3: {
                        if (facing.method_35834(class_2350.class_2351.field_11048) == side || facing.method_35834(class_2350.class_2351.field_11052) == side || facing.method_35834(class_2350.class_2351.field_11051) == side) continue block21;
                        outputDirections.add(side);
                    }
                }
            }
        }
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        int consumptionSum = 0;
        for (class_2350 direction : outputDirections) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.baseEnergyTransferRate, ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum = (int)((long)consumptionSum + received);
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.baseEnergyTransferRate, Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), (long)consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block24: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block24;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }
}

